/*
Dane wejsciowe (wlasnosci werteksu):
gl_Vertex - pooenie (we wsp. modelu), vec4
gl_Color - kolor, vec4
gl_Normal - normalna, vec3
gl_MultiTexCoord0 - wsprzdne teksturowania (indeks 0), vec4

Parametry:
gl_ModelViewProjectionMatrix = mul(gl_ProjectionMatrix,gl_ModelViewMatrix), mat4
gl_NormalMatrix, mat3 (transponowane elementy z gl_ModelViewMatrix przyciete do mat3)

Dane wyjsciowe (wlasnosci werteksu):
gl_Position - pozycja (obowizkowe!), vec4
gl_FrontColor - kolor, vec4
*/

varying vec2 wspTeksturowania;
varying vec4 pozycja0, pozycja1, pozycja2;

void main(void)
{
    // przeksztacenia model-widok
    //gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;   
    gl_Position = mul(gl_ProjectionMatrix,gl_ModelViewMatrix) * gl_Vertex;   

    pozycja0 = gl_Vertex;
    pozycja1 = gl_ModelViewMatrix*gl_Vertex;
    pozycja2 = gl_Position;

    gl_FrontColor = gl_Color;

    wspTeksturowania = vec2(gl_MultiTexCoord0); 
}
